/*------------------------------------------------------------------------------*
 * File Name: ScalerPropertyEdit.c												*
 * Creation: Hong 07/12/07														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 07-17-2007 MAKE_SIMPLE_GUI												*
 *	Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER				*
 *	Hong 07/18/07 QA80-9062 v8.0662 GETN_SHOULD_INITIAL_BY_OBJECT_PROPERTY		*
 *	Sim 07-25-2007 MAKE_CONVENIENT_GUI											*
 *	Hong 08/17/07 v8.0684 CHEAN_APPLY_FORMAT_SUPPORT_UNDO						*
 *	Hong 11/02/07 QA80-10561 MORE_DETAIL_OPTION									*
 *	Folger 11/30/07 ADD_F1_HELP													*
 *	Kyle 08/18/2009 QA80-14152 GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <GetNbox.h>
#include <xfutils.h>
#include <..\originlab\okThemeID.h>
#include <o8dlg.h>			//------ Folger 11/30/07 ADD_F1_HELP
////////////////////////////////////////////////////////////////////////////////////
///---Sim 07-17-2007 MAKE_SIMPLE_GUI
#define COSTUM_COLOR_BIT	COLORLIST_SINGLE|COLORLIST_CUSTOM
///---END MAKE_SIMPLE_GUI

// Start your functions here.
///---Sim 07-17-2007 MAKE_SIMPLE_GUI
/*
static void _construct_dimension_contents(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	
	GETN_LIST(Units, _L("Units"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	GETN_ID(OTID_LABEL_DIMENSION_UNITS)
	GETN_LIST(Attachment, _L("Attachment"), 0, _L("Layer|Page|Scale"))	GETN_ID(OTID_LABEL_DIMENSION_ATTACHMENT)
	GETN_NUM(Left, _L("Left"), 0.0)	GETN_ID(OTID_LABEL_DIMENSION_LEFT)
	GETN_NUM(Top, _L("Top"), 0.0)	GETN_ID(OTID_LABEL_DIMENSION_TOP)
}

static void _construct_background_contents(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	
	GETN_BEGIN_BRANCH(Dimension, _L("Dimension"))	GETN_ID_BRANCH(OTID_LABEL_BKGND_BOUNDS)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_NUM(Left, _L("Left"), 0.0)	GETN_ID(OTID_LABEL_BKGND_BOUNDS_LEFT)
		GETN_NUM(Top, _L("Top"), 0.0)	GETN_ID(OTID_LABEL_BKGND_BOUNDS_TOP)
		GETN_NUM(Right, _L("Right"), 0.0)	GETN_ID(OTID_LABEL_BKGND_BOUNDS_RIGHT)
		GETN_NUM(Bottom, _L("Top"), 0.0)	GETN_ID(OTID_LABEL_BKGND_BOUNDS_BOTTOM)
	GETN_END_BRANCH(Dimension)
	
	GETN_BEGIN_BRANCH(Shadow, _L("Shadow"))	GETN_ID_BRANCH(OTID_LABEL_BKGND_SHADOW)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_LIST(Style, _L("Style"), 0, _L("None|Normal|Button"))	GETN_ID(OTID_LABEL_BKGND_SHADOW_STYLE)
	GETN_END_BRANCH(Shadow)
	
	GETN_BEGIN_BRANCH(Border, _L("Border"))	GETN_ID_BRANCH(OTID_LABEL_BKGND_BORDER)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT) GETN_ID(OTID_LABEL_BKGND_BORDER_COLOR)
		GETN_LIST(Style, _L("Style"), 0, _L("Solid|Dash|Dot|Dash Dot|Dash Dot Dot|Short Dash|Short Dot|Short Dash Dot"))	GETN_ID(OTID_LABEL_BKGND_BORDER_STYLE)
		GETN_NUM(Width, _L("Width"), 0.0)	GETN_ID(OTID_LABEL_BKGND_BORDER_WIDTH)
	GETN_END_BRANCH(Border)
	
	GETN_BEGIN_BRANCH(Fill, _L("Fill"))	GETN_ID_BRANCH(OTID_LABEL_BKGND_FILL)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_BEGIN_BRANCH(Pattern, _L("Pattern"))	GETN_ID_BRANCH(OTID_LABEL_BKGND_FILL_PATTERN)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
			GETN_NUM(Style, _L("Style"), 0)	GETN_ID(OTID_LABEL_BKGND_FILL_PATTERN_STYLE) //--
		GETN_END_BRANCH(Pattern)
		
		GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)	GETN_ID(OTID_LABEL_BKGND_FILL_COLOR)
	GETN_END_BRANCH(Fill)
}

static void _construct_axis_title_contents(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	
	GETN_BEGIN_BRANCH(Dimension, _L("Dimension"))	GETN_ID_BRANCH(OTID_TITLE_DIMENSION)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_LIST(Units, _L("Units"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	GETN_ID(OTID_TITLE_DIMENSION_UNITS)
		GETN_NUM(XOffset, _L("XOffset"), 0.0)	GETN_ID(OTID_TITLE_DIMENSION_XOFFSET)
		GETN_NUM(YOffset, _L("YOffset"), 0.0)	GETN_ID(OTID_TITLE_DIMENSION_YOFFSET)
	GETN_END_BRANCH(Dimension)
	
	GETN_BEGIN_BRANCH(Font, _L("Font"))	GETN_ID_BRANCH(OTID_TITLE_FONT)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_NUM(Face, _L("Face"), 0)	GETN_ID(OTID_TITLE_FONT_FACE) //--
		GETN_NUM(Size, _L("Size"), 12)	GETN_ID(OTID_TITLE_FONT_SIZE)
	GETN_END_BRANCH(Font)
	
	GETN_BEGIN_BRANCH(Alignment, _L("Alignment"))	GETN_ID_BRANCH(OTID_TITLE_ALIGNMENT)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_LIST(Horizontal, _L("Horizontal"), 0, _L("Left|Center|Right"))	GETN_ID(OTID_TITLE_ALIGNMENT_HORZ)
		GETN_LIST(Vertical, _L("Vertical"), 0, _L("Top|Center|Baseline|Bottom"))	GETN_ID(OTID_TITLE_ALIGNMENT_VERT)
	GETN_END_BRANCH(Alignment)
	
	GETN_CHECK(Show, _L("Visable"), 1)	GETN_ID(OTID_TITLE_SHOW)
	GETN_STR(Text, _L("Text"), "")	GETN_ID(OTID_TITLE_TEXT)
	GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)	GETN_ID(OTID_TITLE_COLOR)
	GETN_NUM(Angle, _L("Angle"), 0.0)	GETN_ID(OTID_TITLE_ANGLE)
}

static void _construct_axis_contents(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	
	GETN_BEGIN_BRANCH(Dimension, _L("Dimension"))	GETN_ID_BRANCH(OTID_SCALER_AXIS_DIMENSION)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_LIST(Units, _L("Units"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	GETN_ID(OTID_SCALER_AXIS_DIMENSION_UNITS)
		GETN_LIST(Postion, _L("Postion"), 0, _L("None|Begin|Middle|End"))	GETN_ID(OTID_SCALER_AXIS_DIMENSION_POSITION)
		GETN_NUM(Offset, _L("Offset"), 0.0)	GETN_ID(OTID_SCALER_AXIS_DIMENSION_OFFSET)
		GETN_NUM(Length, _L("Length"), 0.0)	GETN_ID(OTID_SCALER_AXIS_DIMENSION_WIDTH)
	GETN_END_BRANCH(Dimension)
	
	GETN_BEGIN_BRANCH(Arrow, _L("Arrow"))	GETN_ID_BRANCH(OTID_LINE_ARROW)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_BEGIN_BRANCH(Begin, _L("Begin"))	GETN_ID_BRANCH(OTID_LINE_ARROW_BEGIN)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_LIST(Style, _L("Style"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	GETN_ID(OTID_LINE_ARROW_BEGIN_STYLE)
			GETN_NUM(Width, _L("Width"), 0.0)	GETN_ID(OTID_LINE_ARROW_BEGIN_WIDTH)
			GETN_NUM(Length, _L("Length"), 0.0)	GETN_ID(OTID_LINE_ARROW_BEGIN_LENGTH)
			GETN_CHECK(EachSegment, _L("Each Segment"), 0)	GETN_ID(OTID_LINE_ARROW_BEGIN_EACHSEGMENT)
		GETN_END_BRANCH(Begin)
		
		GETN_BEGIN_BRANCH(End, _L("End"))	GETN_ID_BRANCH(OTID_LINE_ARROW_END)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_LIST(Style, _L("Style"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	GETN_ID(OTID_LINE_ARROW_END_STYLE)
			GETN_NUM(Width, _L("Width"), 0.0)	GETN_ID(OTID_LINE_ARROW_END_WIDTH)
			GETN_NUM(Length, _L("Length"), 0.0)	GETN_ID(OTID_LINE_ARROW_END_LENGTH)
			GETN_CHECK(EachSegment, _L("Each Segment"), 0)	GETN_ID(OTID_LINE_ARROW_END_EACHSEGMENT)
		GETN_END_BRANCH(End)
	GETN_END_BRANCH(Arrow)
	
	GETN_BEGIN_BRANCH(Title, _L("Title"))	GETN_ID_BRANCH(OTID_SCALER_AXIS_TITLE)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
	GETN_END_BRANCH(Title)
	
	GETN_CHECK(Show, _L("Visable"), 1)	GETN_ID(OTID_LINE_SHOW)
	GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)	GETN_ID(OTID_LINE_COLOR)
	GETN_LIST(Style, _L("Style"), 0, _L("Solid|Dash|Dot|Dash Dot|Dash Dot Dot|Short Dash|Short Dot|Short Dash Dot"))	GETN_ID(OTID_LINE_STYLE)			
	GETN_NUM(Width, _L("Width"), 0.0)	GETN_ID(OTID_LINE_WIDTH)
	
	_construct_axis_title_contents(trGUI.Title);
}

static void _construct_axes_contents(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	
	GETN_BEGIN_BRANCH(X, _L("X"))	GETN_ID_BRANCH(OTID_SCALER_AXIS)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(X)
	
	GETN_BEGIN_BRANCH(Y, _L("Y"))	GETN_ID_BRANCH(OTID_SCALER_AXIS)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(Y)
	
	_construct_axis_contents(trGUI.X);
	_construct_axis_contents(trGUI.Y);
}
	
static void _construct_scale_property_edit_tree(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	GETN_BEGIN_BRANCH(Dimension, _L("Dimension"))	GETN_ID_BRANCH(OTID_LABEL_DIMENSION)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
	GETN_END_BRANCH(Dimension)
	
	GETN_BEGIN_BRANCH(BackGround, _L("BackGround"))	GETN_ID_BRANCH(OTID_LABEL_BKGND)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(BackGround)
	
	GETN_BEGIN_BRANCH(Axes, _L("Axes"))	GETN_ID_BRANCH(OTID_SCALER_AXES)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(Axes)
	
	GETN_CHECK(Show, _L("Visable"), 1)	GETN_ID(OTID_SCALER_SHOW)
	GETN_CHECK(BehindData, _L("BehindData"), 0)	GETN_ID(OTID_GROBJ_BEHINDDATA)
	GETN_CHECK(KeepInside, _L("KeepInside"), 0)	GETN_ID(OTID_GROBJ_KEEPINSIDE)
	GETN_NUM(States, _L("States"), 0)	GETN_ID(OTID_GROBJ_STATES)
//	GETN_LIST(Event, _L("Event"), 0, _L("None|Button Up|Moved|Sized|Moved or Sized|Redrawn|Real-Time|Window Create|Window Close|Window Activate|Window Deactivate|New Selection|Before Save|Axes Rescale|All Events"))	GETN_ID(OTID_GROBJ_CMDTYPE)
//	GETN_STR(Script, _L("Script"), "")	GETN_ID(OTID_GROBJ_CMD)

	_construct_dimension_contents(trGUI.Dimension);
	_construct_background_contents(trGUI.BackGround);
	_construct_axes_contents(trGUI.Axes);
}


static void _get_set_scale_property_edit_tree(TreeNode& trGetN, TreeNode& trProp, bool bGet = true)
{
	TreeNode trGetNDimension = trGetN.Dimension;
	TreeNode trPropDimension = tree_get_node_by_id(trProp, OTID_LABEL_DIMENSION, true);	
	if ( bGet )
		octree_copy_values_by_id(&trGetNDimension, &trPropDimension, false, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
	else
		octree_copy_values_by_id(&trPropDimension, &trGetNDimension, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
	
	TreeNode trGetNBackGround = trGetN.BackGround;
	TreeNode trPropBackGround = tree_get_node_by_id(trProp, OTID_LABEL_BKGND, true);
	if ( bGet )
		octree_copy_values_by_id(&trGetNBackGround, &trPropBackGround, false, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
	else
		octree_copy_values_by_id(&trPropBackGround, &trGetNBackGround, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
	
	TreeNode trGetNAxes = trGetN.Axes;
	// the following hard code is due to same base ID for X and Y axis and ID of Axes is NOT the same as OTID_SCALER_AXES
	//TreeNode trPropAxes = tree_get_node_by_id(trProp, OTID_SCALER_AXES, true);	
	TreeNode trPropAxes = trProp.Axes;
	if ( trPropAxes )
	{
		TreeNode trGetNX = trGetNAxes.X;
		TreeNode trPropX = trPropAxes.X;
		if ( bGet )
			octree_copy_values_by_id(&trGetNX, &trPropX, false, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
		else
			octree_copy_values_by_id(&trPropX, &trGetNX, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
		
		TreeNode trGetNY = trGetNAxes.Y;
		TreeNode trPropY = trPropAxes.Y;
		if ( bGet )
			octree_copy_values_by_id(&trGetNY, &trPropY, false, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
		else
			octree_copy_values_by_id(&trPropY, &trGetNY, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
	}
	
	//TreeNode trGetNShow = trGetN.Show; //"Show" is keyword
	TreeNode trGetNShow = trGetN.GetNode("Show");
	TreeNode trPropShow = tree_get_node_by_id(trProp, OTID_SCALER_SHOW);	
	if ( bGet )
		trPropShow.nVal = trGetNShow.nVal;
	else
		trGetNShow.nVal = trPropShow.nVal;
	
	TreeNode trGetNBehindData = trGetN.BehindData;
	TreeNode trPropBehindData = tree_get_node_by_id(trProp, OTID_GROBJ_BEHINDDATA);	
	if ( bGet )
		trPropBehindData.nVal = trGetNBehindData.nVal;
	else
		trGetNBehindData.nVal = trPropBehindData.nVal;
	
	TreeNode trGetNKeepInside = trGetN.KeepInside;
	TreeNode trPropKeepInside = tree_get_node_by_id(trProp, OTID_GROBJ_BEHINDDATA);	
	if ( bGet )
		trPropKeepInside.nVal = trGetNKeepInside.nVal;
	else
		trGetNKeepInside.nVal = trPropKeepInside.nVal;
	
	TreeNode trGetNStates = trGetN.States;
	TreeNode trPropStates = tree_get_node_by_id(trProp, OTID_GROBJ_STATES);	
	if ( bGet )
		trPropStates.nVal = trGetNStates.nVal;
	else
		trGetNStates.nVal = trPropStates.nVal;
	
//	TreeNode trGetNEvent = trGetN.Event;
//	TreeNode trPropEvent = tree_get_node_by_id(trProp, OTID_GROBJ_CMDTYPE);	
//	if ( bGet )
//		trPropEvent.nVal = trGetNEvent.nVal;
//	else
//		trGetNEvent.nVal = trPropEvent.nVal;
//	
//	TreeNode trGetNScript = trGetN.Script;
//	TreeNode trPropScript = tree_get_node_by_id(trProp, OTID_GROBJ_CMD);	
//	if ( bGet )
//		trPropScript.strVal = trGetNScript.strVal;
//	else
//		trGetNScript.strVal = trPropScript.strVal;
	
}
*/

static void _construct_axis_title_contents(TreeNode& trTitle)
{
	GETN_USE(trTitle)
	
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	GETN_COMBO(Angle, _L("Rotation Angle"), 0, "|0|90|180|270")
	GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)
	///---END MAKE_CONVENIENT_GUI
	//GETN_CHECK(Show, _L("Visable"), 1)	GETN_ID(OTID_TITLE_SHOW)
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	//GETN_STR(Text, _L("Text"), "")	//GETN_ID(OTID_TITLE_TEXT)
	///---END MAKE_CONVENIENT_GUI
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	/*
	/// Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
	GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)//	GETN_ID(OTID_TITLE_COLOR)
	/// end MORE_ADVANCE_OPTION_FOR_SCALER
	GETN_COMBO(Size, _L("Font Size"), 12, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72")	/// Hong 07/19/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
	*/
	//GETN_BEGIN_BRANCH(Dimension, _L("Offset"))	//GETN_ID_BRANCH(OTID_TITLE_DIMENSION)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
	GETN_BEGIN_BRANCH(Dimension, _L("Offset (% of Layer)"))	//GETN_ID_BRANCH(OTID_TITLE_DIMENSION)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
	///---END MAKE_CONVENIENT_GUI
	//	GETN_LIST(Units, _L("Units"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	//GETN_ID(OTID_TITLE_DIMENSION_UNITS)
		GETN_NUM(XOffset, _L("X"), 0.0)//	GETN_ID(OTID_TITLE_DIMENSION_XOFFSET)
		GETN_NUM(YOffset, _L("Y"), 0.0)//	GETN_ID(OTID_TITLE_DIMENSION_YOFFSET)
	GETN_END_BRANCH(Dimension)

	
	GETN_BEGIN_BRANCH(Alignment, _L("Alignment"))	//GETN_ID_BRANCH(OTID_TITLE_ALIGNMENT)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		GETN_LIST(Horizontal, _L("Horizontal"), 0, _L("Left|Center|Right"))	//GETN_ID(OTID_TITLE_ALIGNMENT_HORZ)
		GETN_LIST(Vertical, _L("Vertical"), 0, _L("Top|Center|Baseline|Bottom"))	//GETN_ID(OTID_TITLE_ALIGNMENT_VERT)
	GETN_END_BRANCH(Alignment)	
}
///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
/*
/// Hong 07/24/07 v8.0666 CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
//static void _construct_axis_contents(TreeNode& trAxis)
///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
//static void _construct_axis_contents(TreeNode& trAxis, bool bX = true)
static void _construct_axis_addition(TreeNode& trAxisAddition, bool bX = true)
///---END MAKE_CONVENIENT_GUI
/// end CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
{
	/// Hong 07/24/07 v8.0666 CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
	string strPosition;
	if ( bX )
		strPosition = _L("None|Bottom|Middle|Top");
	else
		strPosition = _L("None|Left|Middle|Right");
	/// end CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	//GETN_USE(trAxis)
	GETN_USE(trAxisAddition)
	///---END MAKE_CONVENIENT_GUI
	
	//GETN_BEGIN_BRANCH(Dimension, _L("Dimension"))	GETN_ID_BRANCH(OTID_SCALER_AXIS_DIMENSION)//	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		//GETN_LIST(Units, _L("Units"), 0, _L("inch|cm|mm|pixel|point|scale|% of layer|% of page"))	GETN_ID(OTID_SCALER_AXIS_DIMENSION_UNITS)
		/// Hong 07/19/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
		/// Hong 07/24/07 v8.0666 CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
		//GETN_LIST(Position, _L("Position"), 0, _L("None|Begin|Middle|End"))	//GETN_ID(OTID_SCALER_AXIS_DIMENSION_POSITION)
		GETN_LIST(Position, _L("Position"), 0, strPosition)
		/// end CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
		/// end MORE_ADVANCE_OPTION_FOR_SCALER
		//GETN_NUM(Offset, _L("Offset"), 0.0)	GETN_ID(OTID_SCALER_AXIS_DIMENSION_OFFSET)
		///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
		//GETN_NUM(Length, _L("Length"), 0.0)	//GETN_ID(OTID_SCALER_AXIS_DIMENSION_WIDTH)
		///---END MAKE_CONVENIENT_GUI
	//GETN_END_BRANCH(Dimension)
	/// Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
	GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)//	GETN_ID(OTID_LINE_COLOR)
	/// end MORE_ADVANCE_OPTION_FOR_SCALER
	
	/// Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
	GETN_BEGIN_BRANCH(Title, _L("Title"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) //GETN_ID_BRANCH(OTID_SCALER_AXIS_TITLE)	 
	GETN_END_BRANCH(Title)
	//GETN_STR(TitleText, _L("Title Text"), "")	//GETN_ID(OTID_TITLE_TEXT)
	/// end MORE_ADVANCE_OPTION_FOR_SCALER
	
	//GETN_CHECK(Show, _L("Visable"), 1)	GETN_ID(OTID_LINE_SHOW)
	
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	//_construct_axis_title_contents(trAxis.Title); /// Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
	_construct_axis_title_contents(trAxisAddition.Title);
	///---END MAKE_CONVENIENT_GUI
}
*/
///---END MAKE_CONVENIENT_GUI

///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
static void _construct_axis_contents(TreeNode& trAxis, bool bX = true)
{
	GETN_USE(trAxis)
	
	string strPosition;
	if ( bX )
		strPosition = _L("None|Bottom|Middle|Top");
	else
		strPosition = _L("None|Left|Middle|Right");
	/// Hong 11/09/07 v8.744 FIX_MISS_UNITS_IN_LENGTH
	//GETN_LIST(Position, _L("Position(Scale)"), 0, strPosition)
	
	//GETN_NUM(Length, _L("Length"), 0.0)	//GETN_ID(OTID_SCALER_AXIS_DIMENSION_WIDTH)	
	GETN_LIST(Position, _L("Position"), 0, strPosition)
	
	GETN_NUM(Length, _L("Length(Scale)"), 0.0)	//GETN_ID(OTID_SCALER_AXIS_DIMENSION_WIDTH)	
	/// end FIX_MISS_UNITS_IN_LENGTH
	GETN_NUM(Width, _L("Width"), 0.0) /// Hong 11/02/07 QA80-10561 MORE_DETAIL_OPTION	
	GETN_STR(TitleText, _L("Title"), "")
	
	//GETN_BEGIN_BRANCH(Addition, _L("Addition"))	//GETN_ID_BRANCH(OTID_SCALER_AXIS_TITLE)	 
	//GETN_END_BRANCH(Addition)
	GETN_BEGIN_BRANCH(Title, _L("Title Properties"))	//GETN_OPTION_BRANCH(GETNBRANCH_OPEN) //GETN_ID_BRANCH(OTID_SCALER_AXIS_TITLE)	 
	GETN_END_BRANCH(Title)
	/// Hong 11/02/07 QA80-10561 MORE_DETAIL_OPTION
	GETN_BEGIN_BRANCH(Arrow, _L("Arrow"))
		GETN_NUM(Width, _L("Width"), 0.0)
	GETN_END_BRANCH(Arrow)
	/// end MORE_DETAIL_OPTION
	
	//_construct_axis_addition(trAxis.Addition, bX);
	
	_construct_axis_title_contents(trAxis.Title);
}
///---END MAKE_CONVENIENT_GUI

///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
/*
static void _construct_xy_axis_contents(TreeNode& trXYAxis)
{
	GETN_USE(trXYAxis)
	
	GETN_BEGIN_BRANCH(X, _L("X"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(X)
	GETN_BEGIN_BRANCH(Y, _L("Y"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(Y)
	
	_construct_axis_contents(trXYAxis.X);
	/// Hong 07/24/07 v8.0666 CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
	//_construct_axis_contents(trXYAxis.Y);
	_construct_axis_contents(trXYAxis.Y, false);
	/// end CHANGE_LABEL_FOR_POSITION_ASKED_BY_SNOW
}
*/
enum{
	LIST_Y_SCALE = 0,
	LIST_X_SCALE,
	LIST_XY_SCALE,
};

static void _construct_scale_property_edit_tree(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	GETN_LIST(Scales, _L("Scales"), LIST_XY_SCALE, _L("Y Scale|X Scale|XY Scales"))
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	GETN_COLOR(Color, _L("Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COSTUM_COLOR_BIT)//	GETN_ID(OTID_TITLE_COLOR)
	///Kyle 08/18/2009 QA80-14152 GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
	//GETN_COMBO(Size, _L("Font Size"), 12, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72")
	GETN_BEGIN_BRANCH(FontSettings, _L("Font Settings"))
		GETN_FONT(Face, _L("Font"), -1)
		GETN_COMBO(Size, _L("Font Size"), 12, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72")
		GETN_CHECK(Bold, _L("Bold"), 0)
		GETN_CHECK(Italic, _L("Italic"), 0)
		GETN_CHECK(Underline, _L("Underline"), 0)
	GETN_END_BRANCH(FontSettings)
	///End GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
	
	//GETN_BEGIN_BRANCH(Axes, _L("Axes"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	//GETN_END_BRANCH(Axes)
	
	//_construct_xy_axis_contents(trGUI.Axes);
	GETN_BEGIN_BRANCH(X, _L("X"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(X)
	GETN_BEGIN_BRANCH(Y, _L("Y"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_BRANCH(Y)
	
	_construct_axis_contents(trGUI.X);
	_construct_axis_contents(trGUI.Y, false);
	///---END MAKE_CONVENIENT_GUI
}

#define IS_SHOW_X_AXIS(_SCALES) (LIST_X_SCALE == _SCALES || LIST_XY_SCALE == _SCALES)
#define IS_SHOW_Y_AXIS(_SCALES) (LIST_Y_SCALE == _SCALES || LIST_XY_SCALE == _SCALES)

///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
//static void _update_axis(TreeNode& trGetNAxis, const TreeNode& trGoAxis, bool bShowAxis, bool bToGraphObject = true)
static void _update_axis(TreeNode& trGetN, TreeNode& trGetNAxis, const TreeNode& trGoAxis, bool bShowAxis, bool bToGraphObject = true)
///---END MAKE_CONVENIENT_GUI
{
	if ( bToGraphObject )
	{
		TreeNode trShow = trGoAxis.GetNode("Show");
		if ( bShowAxis )
		{
			trShow.nVal = 1;
			
			///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
			/*
			trGoAxis.Dimension.Length.dVal	= trGetNAxis.Length.dVal;			
			trGoAxis.Dimension.Position.nVal	= trGetNAxis.Position.nVal;
			/// Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
			//trGoAxis.Title.GetNode("Text").strVal 		= trGetNAxis.TitleText.strVal;
			trGoAxis.Color.nVal	= trGetNAxis.Color.nVal;			
			using trGoTitle = trGoAxis.Title;
			using trGetNTitle = trGetNAxis.Title;
			trGoTitle.GetNode("Text").strVal = trGetNTitle.GetNode("Text").strVal;
			trGoTitle.Color.nVal = trGetNTitle.Color.nVal;
			trGoTitle.Dimension.XOffset.dVal = trGetNTitle.Dimension.XOffset.dVal;
			trGoTitle.Dimension.YOffset.dVal = trGetNTitle.Dimension.YOffset.dVal;
			trGoTitle.Alignment.Horizontal.nVal = trGetNTitle.Alignment.Horizontal.nVal;
			trGoTitle.Alignment.Vertical.nVal = trGetNTitle.Alignment.Vertical.nVal;
			/// end MORE_ADVANCE_OPTION_FOR_SCALER
			trGoTitle.Font.Size.dVal = trGetNTitle.Size.dVal;/// Hong 07/19/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER			
			*/
			using trGoTitle = trGoAxis.Title;
			using trGetNTitle = trGetNAxis.Title;
			
			trGoAxis.Dimension.Length.dVal	= trGetNAxis.Length.dVal;			
			trGoTitle.GetNode("Text").strVal = trGetNAxis.TitleText.strVal;
			
			if ( trGetNAxis.Position.Show )
				trGoAxis.Dimension.Position.nVal	= trGetNAxis.Position.nVal;
			else
				trGoAxis.Dimension.Position.nVal	= 1;
			//trGoAxis.Color.nVal	= trGetNAxis.Color.nVal;
			trGoAxis.Color.nVal = trGetN.Color.nVal;
			
			trGoTitle.Angle.dVal = trGetNTitle.Angle.nVal;
			//trGoTitle.Color.nVal = trGetNTitle.Color.nVal;
			//trGoTitle.Color.nVal = trGetN.Color.nVal; /// Hong 11/02/07 QA80-10561 MORE_DETAIL_OPTION
			trGoTitle.Dimension.XOffset.dVal = trGetNTitle.Dimension.XOffset.dVal;
			trGoTitle.Dimension.YOffset.dVal = trGetNTitle.Dimension.YOffset.dVal;
			trGoTitle.Alignment.Horizontal.nVal = trGetNTitle.Alignment.Horizontal.nVal;
			trGoTitle.Alignment.Vertical.nVal = trGetNTitle.Alignment.Vertical.nVal;
			//trGoTitle.Font.Size.dVal = trGetNTitle.Size.dVal;/// Hong 07/19/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER			
			///Kyle 08/18/2009 QA80-14152 GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
			//trGoTitle.Font.Size.dVal = trGetN.Size.dVal;
			TreeNode trFontSettings = trGetN.FontSettings;
			TreeNode trFontFmt = trGoTitle.Font;
			if(trFontSettings && trFontFmt)
			{
				trFontFmt.Face.nVal = trFontSettings.Face.nVal;
				trFontFmt.Size.nVal = trFontSettings.Size.nVal;
				trFontFmt.Bold.nVal = trFontSettings.Bold.nVal;
				trFontFmt.Italic.nVal = trFontSettings.Italic.nVal;
				trFontFmt.Underline.nVal = trFontSettings.Underline.nVal;
			}
			///End GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
			///---END MAKE_CONVENIENT_GUI
			/// Hong 11/02/07 QA80-10561 MORE_DETAIL_OPTION
			trGoAxis.Width.dVal	= trGetNAxis.Width.dVal;
			trGoAxis.Arrow.Begin.Width.dVal = trGetNAxis.Arrow.Width.dVal;
			trGoAxis.Arrow.End.Width.dVal = trGetNAxis.Arrow.Width.dVal;
			trGoTitle.Color.nVal = trGetNTitle.Color.nVal;
			/// end MORE_DETAIL_OPTION
		}
		else
			trShow.nVal = 0;
	}
	else // to GetN tree
	{
		// not care about show axis setting, always init getn tree with current graph object
		///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
		/*
		trGetNAxis.Length.dVal 		= trGoAxis.Dimension.Length.dVal;
		trGetNAxis.Position.nVal	= trGoAxis.Dimension.Position.nVal;
		/// Hong 07/18/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
		//trGetNAxis.TitleText.strVal	= trGoAxis.Title.GetNode("Text").strVal;
		trGetNAxis.Color.nVal	= trGoAxis.Color.nVal;
		using trGoTitle = trGoAxis.Title;
		using trGetNTitle = trGetNAxis.Title;
		trGetNTitle.GetNode("Text").strVal = trGoTitle.GetNode("Text").strVal;
		trGetNTitle.Color.nVal = trGoTitle.Color.nVal;
		trGetNTitle.Dimension.XOffset.dVal = trGoTitle.Dimension.XOffset.dVal;
		trGetNTitle.Dimension.YOffset.dVal = trGoTitle.Dimension.YOffset.dVal;
		trGetNTitle.Alignment.Horizontal.nVal = trGoTitle.Alignment.Horizontal.nVal;
		trGetNTitle.Alignment.Vertical.nVal = trGoTitle.Alignment.Vertical.nVal;
		/// end MORE_ADVANCE_OPTION_FOR_SCALER
		trGetNTitle.Size.dVal = trGoTitle.Font.Size.dVal;/// Hong 07/19/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER
		*/
		using trGoTitle = trGoAxis.Title;
		using trGetNTitle = trGetNAxis.Title;
		
		trGetNAxis.Length.dVal = trGoAxis.Dimension.Length.dVal;			
		trGetNAxis.TitleText.strVal = trGoTitle.GetNode("Text").strVal;
		
		trGetNAxis.Position.nVal = trGoAxis.Dimension.Position.nVal;
		//trGetNAxis.Color.nVal = trGoAxis.Color.nVal;
		trGetN.Color.nVal = trGoAxis.Color.nVal;
		
		trGetNTitle.Angle.dVal = trGoTitle.Angle.nVal;
		//trGetNTitle.Color.nVal = trGoTitle.Color.nVal;
		trGetNTitle.Dimension.XOffset.dVal = trGoTitle.Dimension.XOffset.dVal;
		trGetNTitle.Dimension.YOffset.dVal = trGoTitle.Dimension.YOffset.dVal;
		trGetNTitle.Alignment.Horizontal.nVal = trGoTitle.Alignment.Horizontal.nVal;
		trGetNTitle.Alignment.Vertical.nVal = trGoTitle.Alignment.Vertical.nVal;
		//trGetNTitle.Size.dVal = trGoTitle.Font.Size.dVal;/// Hong 07/19/07 QA80-9062 v8.0662 MORE_ADVANCE_OPTION_FOR_SCALER			
		///Kyle 08/18/2009 QA80-14152 GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
		//trGetN.Size.dVal = trGoTitle.Font.Size.dVal;
		TreeNode trFontSettings = trGetN.FontSettings;
		TreeNode trFontFmt = trGoTitle.Font;
		if(trFontSettings && trFontFmt)
		{
			trFontSettings.Face.nVal = trFontFmt.Face.nVal;
			trFontSettings.Size.nVal = trFontFmt.Size.nVal;
			trFontSettings.Bold.nVal = trFontFmt.Bold ? trFontFmt.Bold.nVal : 0;
			trFontSettings.Italic.nVal = trFontFmt.Italic ? trFontFmt.Italic.nVal : 0;
			trFontSettings.Underline.nVal = trFontFmt.Underline ? trFontFmt.Underline.nVal : 0;
		}
		///End GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
		///---END MAKE_CONVENIENT_GUI
		/// Hong 11/02/07 QA80-10561 MORE_DETAIL_OPTION
		trGetNAxis.Width.dVal	= trGoAxis.Width.dVal;
		trGetNAxis.Arrow.Width.dVal = trGoAxis.Arrow.Begin.Width.dVal;	
		trGetNTitle.Color.nVal = trGoTitle.Color.nVal;
		/// end MORE_DETAIL_OPTION
	}
}

static void _update_scale_property_edit_tree(TreeNode& trGetN, const TreeNode& trProp, bool bToGraphObject = true)
{
	/// Hong 07/18/07 QA80-9062 v8.0662 GETN_SHOULD_INITIAL_BY_OBJECT_PROPERTY	
	//int nScales	= trGetN.Scales.nVal;
	//_update_axis(trGetN.Axes.X, trProp.Axes.X, bToGraphObject ? IS_SHOW_X_AXIS(nScales) : true, bToGraphObject);
	//_update_axis(trGetN.Axes.Y, trProp.Axes.Y, bToGraphObject ? IS_SHOW_Y_AXIS(nScales) : true, bToGraphObject);
	if ( !bToGraphObject )
	{
		bool bXAxisViable = trProp.Axes.X.GetNode("Show").nVal;
		bool bYAxisViable = trProp.Axes.Y.GetNode("Show").nVal;
		if ( bXAxisViable && bYAxisViable )			
			trGetN.Scales.nVal = LIST_XY_SCALE;
		else if ( bXAxisViable )
			trGetN.Scales.nVal = LIST_X_SCALE;
		else if ( bYAxisViable )
			trGetN.Scales.nVal = LIST_Y_SCALE;			
	}
	int nScales = trGetN.Scales.nVal;
		
	///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
	//_update_axis(trGetN.Axes.X, trProp.Axes.X, IS_SHOW_X_AXIS(nScales), bToGraphObject);
	//_update_axis(trGetN.Axes.Y, trProp.Axes.Y, IS_SHOW_Y_AXIS(nScales), bToGraphObject);
	_update_axis(trGetN, trGetN.X, trProp.Axes.X, IS_SHOW_X_AXIS(nScales), bToGraphObject);
	_update_axis(trGetN, trGetN.Y, trProp.Axes.Y, IS_SHOW_Y_AXIS(nScales), bToGraphObject);
	///---END MAKE_CONVENIENT_GUI
	/// end GETN_SHOULD_INITIAL_BY_OBJECT_PROPERTY	
}
///---END MAKE_SIMPLE_GUI

///---Sim 07-17-2007 MAKE_SIMPLE_GUI
//static bool _get_scaler_and_format_tree(GraphObject& go, TreeNode& trFmt, int nIndex)
static bool _get_scaler_and_format_tree(GraphObject& go, int nIndex)
///---END MAKE_SIMPLE_GUI
{
	GraphLayer gl = Project.ActiveLayer();	
	if ( !gl )
		return false;
	
	go = gl.GraphObjects(nIndex);	
	if ( !go )
		return false;
	
	///---Sim 07-17-2007 MAKE_SIMPLE_GUI
	/*
	trFmt = go.GetFormat(FPB_ALL, FOB_ALL, true, true);
	if ( !trFmt || trFmt.IsEmpty() )
		return false;
	*/
	///---END MAKE_SIMPLE_GUI
	
	return true;
}

///---Sim 07-17-2007 MAKE_SIMPLE_GUI
//static bool _update_scaler_property(GraphObject& go, TreeNode& trGetN)
static bool _update_scaler_property(GraphObject& go, TreeNode& trGetN, bool bToGraphObject = true)
///---END MAKE_SIMPLE_GUI
{
	Tree trFmt;
	trFmt = go.GetFormat(FPB_ALL, FOB_ALL, true, true);
	TreeNode trProp = trFmt.Root;
	
	///---Sim 07-17-2007 MAKE_SIMPLE_GUI
	if ( bToGraphObject )
	{
		//_get_set_scale_property_edit_tree(trGetN, trProp);
		_update_scale_property_edit_tree(trGetN, trProp, true); // from getn to go		
		go.UpdateThemeIDs(trFmt.Root);							///Kyle 08/18/2009 QA80-14152 GRAPH_SCALE_OBJECT_DIALOG_ADD_FONT_STYLE_CONTROL
		//go.ApplyFormat(trFmt, true, true); 
		go.ApplyFormat(trFmt, true, true, true);  /// Hong 08/17/07 v8.0684 CHEAN_APPLY_FORMAT_SUPPORT_UNDO
	}
	else // to GetN
	{
		_update_scale_property_edit_tree(trGetN, trProp, false); // from go to getn
	}
	///---END MAKE_SIMPLE_GUI
	return true;
}

static int scaler_getn_event(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	DECLARE_BUTTON_ENABLES
		
	if(nEvent == GETNE_ON_APPLY)
	{
		TreeNode trObjIndex = tr.ObjIndex;
		int nIndex = trObjIndex.nVal;
		
		GraphObject go;
		///---Sim 07-17-2007 MAKE_SIMPLE_GUI
		/*
		Tree trFmt;
		if ( !_get_scaler_and_format_tree(go, trFmt, nIndex) )
			return false;
		
		TreeNode trProp = trFmt.Root;
		*/
		if ( !_get_scaler_and_format_tree(go, nIndex) )
			return false;
		///---END MAKE_SIMPLE_GUI
	
		_update_scaler_property(go, tr);
		
		return true;
	}
	
	if ( 0 == lstrcmp(lpcszNodeName, "Scales") || nEvent == GETNE_ON_INIT )
	{
		int nScales = tr.Scales.nVal;
		
		///---Sim 07-25-2007 MAKE_CONVENIENT_GUI
		//tr.Axes.X.Show = IS_SHOW_X_AXIS(nScales);
		//tr.Axes.Y.Show = IS_SHOW_Y_AXIS(nScales);
		tr.X.Show = IS_SHOW_X_AXIS(nScales);
		tr.Y.Show = IS_SHOW_Y_AXIS(nScales);
		
		tr.X.Position.Show = 0;
		tr.Y.Position.Show = 0;
		if ( LIST_XY_SCALE == nScales )
		{
			tr.X.Position.Show = 1;
			tr.Y.Position.Show = 1;
		}
		///---END MAKE_CONVENIENT_GUI
		
		return true;
	}
	
	return false;
}

BOOL ScalerPropertyEdit(int nIndex = 0) 
{
	GraphObject go;
	///---Sim 07-17-2007 MAKE_SIMPLE_GUI
	/*
	Tree trFmt;
	if ( !_get_scaler_and_format_tree(go, trFmt, nIndex) )
		return false;
	
	TreeNode trProp = trFmt.Root;
	*/
	if ( !_get_scaler_and_format_tree(go, nIndex) )
		return false;
	///---END MAKE_SIMPLE_GUI
	
	GETN_TREE(trGetN);
	_construct_scale_property_edit_tree(trGetN);
	///---Sim 07-17-2007 MAKE_SIMPLE_GUI
	//_get_set_scale_property_edit_tree(trGetN, trProp, false);
	_update_scaler_property(go, trGetN, false);
	///---END MAKE_SIMPLE_GUI
	
	TreeNode trObjIndex = trGetN.AddNumericNode(nIndex, "ObjIndex");
	trObjIndex.Show = 0;
	
	trGetN.SetAttribute(STR_HELPID_ATTRIB, IDD_SCALER_PROP_DLG);		//------ Folger 11/30/07 ADD_F1_HELP
	
	int nRetVal;
	///---Sim 07-17-2007 MAKE_SIMPLE_GUI
	//nRetVal = GetNBox(trGetN, scaler_getn_event, _L("Scaler Property Edit"), _L("Edit Scaler Property"), NULL, true);
	nRetVal = GetNBox(trGetN, scaler_getn_event, _L("Scaler Properties"), NULL, NULL, true);
	///---END MAKE_SIMPLE_GUI
	
	if ( IDOK == nRetVal )
	{
		_update_scaler_property(go, trGetN);
		
		return true;
	}
	
	return false;
}
